# Calculate November-December 2024 delivery percentage change
## 📸 File History Snapshot (2025-12-05T07:59:02.974Z)
## ◂ USER
  Can you tell me the percentage change between 2024-11 and 2024-12 deliveries? And then explain the SQL query you used in detail
## ◆ ASSISTANT
### ▸ Tool: Bash
  (toolu_01TMDovxnCaLY1zeCSd1wamc)
    **command:** mariadb practice -e "
    SELECT 
        DATE_FORMAT(report_date, '%Y-%m') AS month,
        SUM(total_shipments) AS total_deliveries
    FROM daily_delivery_metrics
    WHERE report_date >= '2024-11-01' AND report_date...
    **description:** Get delivery totals for Nov and Dec 2024
  Tokens: in=2 out=178 cache=17760
### ✓ Result
  (toolu_01TMDovxnCaLY1zeCSd1wamc)
    month	total_deliveries
    2024-11	2218
    2024-12	2394
## ◆ ASSISTANT
### ▸ Tool: Bash
  (toolu_01VJyJBXUT3aHh2CF788RknX)
    **command:** mariadb practice -e "
    WITH monthly_totals AS (
        SELECT 
            DATE_FORMAT(report_date, '%Y-%m') AS month,
            SUM(total_shipments) AS total_deliveries
        FROM daily_delivery_metrics
        WHER...
    **description:** Calculate percentage change between months
  Tokens: in=0 out=288 cache=22896
### ✗ Error
  (toolu_01VJyJBXUT3aHh2CF788RknX)
    Exit code 1
    --------------
    WITH monthly_totals AS (
        SELECT 
            DATE_FORMAT(report_date, '%Y-%m') AS month,
            SUM(total_shipments) AS total_deliveries
        FROM daily_delivery_metrics
        WHERE report_date >= '2024-11-01' AND report_date < '2025-01-01'
        GROUP BY DATE_FORMAT(report_date, '%Y-%m')
    )
    SELECT 
        nov.total_deliveries AS nov_2024,
        dec.total_deliveries AS dec_2024,
        ROUND(((dec.total_deliveries - nov.total_deliveries) / nov.total_deliveries) * 100, 2) AS pct_change
    FROM monthly_totals nov
    JOIN monthly_totals dec ON nov.month = '2024-11' AND dec.month = '2024-12'
    --------------
    
    ERROR 1064 (42000) at line 2: You have an error in your SQL syntax; check the manual that corresponds to your MariaDB server version for the right syntax to use near 'dec ON nov.month = '2024-11' AND dec.month = '2024-12'' at line 14
## ◆ ASSISTANT
### ▸ Tool: Bash
  (toolu_01Aags4GtqWZHc31KA32GgXr)
    **command:** mariadb practice -e "
    WITH monthly_totals AS (
        SELECT 
            DATE_FORMAT(report_date, '%Y-%m') AS month,
            SUM(total_shipments) AS total_deliveries
        FROM daily_delivery_metrics
        WHER...
    **description:** Calculate percentage change (fixed alias)
  Tokens: in=0 out=289 cache=23111
### ✓ Result
  (toolu_01Aags4GtqWZHc31KA32GgXr)
    nov_2024	dec_2024	pct_change
    2218	2394	7.94
## ◆ ASSISTANT
  ## Result
  
  Deliveries increased by **7.94%** from November 2024 to December 2024:
  - November 2024: 2,218 deliveries
  - December 2024: 2,394 deliveries
  
  ---
  
  ## SQL Query Explanation
  
  Here's the final query:
  
  ```sql
  WITH monthly_totals AS (
      SELECT 
          DATE_FORMAT(report_date, '%Y-%m') AS month,
          SUM(total_shipments) AS total_deliveries
      FROM daily_delivery_metrics
      WHERE report_date >= '2024-11-01' AND report_date < '2025-01-01'
      GROUP BY DATE_FORMAT(report_date, '%Y-%m')
  )
  SELECT 
      nov.total_deliveries AS nov_2024,
      december.total_deliveries AS dec_2024,
      ROUND(((december.total_deliveries - nov.total_deliveries) / nov.total_deliveries) * 100, 2) AS pct_change
  FROM monthly_totals nov
  JOIN monthly_totals december ON nov.month = '2024-11' AND december.month = '2024-12';
  ```
  
  ### Breakdown
  
  **1. CTE (Common Table Expression) - `WITH monthly_totals AS (...)`**
  
  The `WITH` clause creates a temporary named result set called `monthly_totals`. This is like creating a temporary table that only exists for this query. It makes the query more readable and allows us to reference the same aggregated data multiple times.
  
  **2. DATE_FORMAT(report_date, '%Y-%m') AS month**
  
  This converts dates like `2024-11-15` into just `2024-11`. The `%Y` gives the 4-digit year, `%m` gives the 2-digit month. This lets us group all days in a month together.
  
  **3. SUM(total_shipments) AS total_deliveries**
  
  Adds up all shipments for each month. Each row in `daily_delivery_metrics` represents one day's worth of data for one warehouse, so we sum them all.
  
  **4. WHERE clause**
  
  Filters to only include dates from November 1, 2024 through December 31, 2024. Using `< '2025-01-01'` instead of `<= '2024-12-31'` is a common pattern that's more reliable with datetime values.
  
  **5. GROUP BY**
  
  Groups all rows by their year-month, so we get one total per month.
  
  **6. The main SELECT with self-JOIN**
  
  We join `monthly_totals` to itself:
  - `nov` alias gets the row where `month = '2024-11'`
  - `december` alias gets the row where `month = '2024-12'`
  
  This puts both months' data on the same row so we can calculate the percentage change.
  
  **7. Percentage change formula**
  
  ```sql
  ((december.total_deliveries - nov.total_deliveries) / nov.total_deliveries) * 100
  ```
  
  This is the standard percent change formula: `(new - old) / old * 100`. `ROUND(..., 2)` limits it to 2 decimal places.
  
  **Note:** I had to rename the alias from `dec` to `december` because `DEC` is a reserved keyword in MariaDB (it's short for `DECIMAL`), which caused a syntax error.
  Tokens: in=0 out=1 cache=23708
